import refreshTokenHelper from "../../../../../utils/refreshTokenHelper"
import forceLogoutHelper from "../../../../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../../../../utils/errorHandlingHelper"

const handleFunc = async (event: any, authToken: any = null) => {
  let data: any = {}
  const config = useRuntimeConfig()
  const token = authToken ?? await getTokenHelper(event)
  const body = await readBody(event)

  let newObjValue = {}
  if(body.groupId) {
    newObjValue = {...newObjValue, 
      R_Group_ID: {
        id: body.groupId,
        tableName: 'R_Group'
      }
    }
  }
  if(body.requestTypeId) {
    newObjValue = {...newObjValue, 
      R_RequestType_ID: {
        id: body.requestTypeId,
        tableName: 'R_RequestType'
      }
    }
  }
  if(body.summary) {
    newObjValue = {...newObjValue, 
      summary: body.summary
    }
  }
  if(body.nullColumns) {
    newObjValue = {...newObjValue, 
      nullColumns: body.nullColumns
    }
  }

  if(body.requestId) {
    const res: any = await event.context.fetch('models/r_requestaction', 'POST', token, {
      AD_Org_ID: {
        id: body.organizationId,
        tableName: 'AD_Org'
      },
      R_Request_ID: {
        id: body.requestId,
        tableName: 'R_Request'
      },
      isActive: body.isActive,
      ...newObjValue,
      tableName: 'R_RequestAction'
    })
    if(res) {
      data = res
      data['status'] = 200
      data['message'] = ''
    }
  }

  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    try {
      let authToken: any = await refreshTokenHelper(event)
      data = await handleFunc(event, authToken)
    } catch(error: any) {
      data = errorHandlingHelper(err?.data ?? err, error?.data ?? error)
      forceLogoutHelper(event, data)
    }
  }

  return data
})